//+------------------------------------------------------------------+
//|                                        JC - Line Break Alert.mq4 |
//|                                         Juan Carlos Christensen. |
//|                                     http://www.eumefinancial.com |
//+------------------------------------------------------------------+
#property copyright "Juan Carlos Christensen."
#property link      "http://www.eumefinancial.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Green
#property indicator_color2 Red
#property indicator_width1 2
#property indicator_width2 2

//---- input parameters
extern double Price1 = 2.0000;
extern double Price2 = 2.0000;
extern string Modes = "0- Line; 1- Channel";
extern int Mode = 0;
extern bool UseSoundAlert = True;
extern string SoundFile = "alert.wav";
extern int PlaySoundNTimes = 1;
extern bool UseAlertPopUp = True;
extern bool UseTickMode = True;
extern bool UseSendMail = False;
extern bool DeactivateOnAlert = True;

double PRICE1[];
double PRICE2[];
bool DidBreakout = False;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  //---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,PRICE1);
   
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,PRICE2);
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   //ObjectDelete("Price1");
   //ObjectDelete("Price2");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----

   switch(Mode)
   {
      case 0:
         CrossingPrice1Only();
         break;
      case 1:
         ChannelBreakOut();
         break;
      default:
         CrossingPrice1Only();
   }
   

//----
   return(0);
  }
//+------------------------------------------------------------------+

void CrossingPrice1Only()
{
   int counted_bars =IndicatorCounted();
   int pos =Bars-counted_bars;
   
   double LastPrice;
   double CurrentPrice;
   int x;
   
   while(pos>=0)
   {
      PRICE1[pos]= Price1;
      
      pos--;
   }
   
   if(UseTickMode)
   {
      LastPrice = iClose(NULL, 0, 1);
      CurrentPrice = iClose(NULL, 0, 0);
   }
   else if(UseTickMode == False)
   {
      LastPrice = iOpen(NULL, 0, 1);
      CurrentPrice = iOpen(NULL, 0, 0);
   }

   //int counter = 0;
   
   //while(!ObjectCreate("Price1_" + counter, OBJ_HLINE, 0, 0, Price1) && counter < 100)
   //{
   //   counter++;
   //}
   
   //ObjectSet("Price1", OBJPROP_COLOR, Green);
   
   if(((LastPrice < Price1) && (CurrentPrice >= Price1)) || ((LastPrice > Price1) && (CurrentPrice <= Price1)) && !DidBreakout) 
   {
      if(DeactivateOnAlert)
      {
         DidBreakout = True;
      }
      
      if(UseSoundAlert)
      {
         for(x=0;x<=PlaySoundNTimes;x++)
         {
            PlaySound(SoundFile);
         }
      }
      
      if(UseAlertPopUp)
      {
         Alert("Price Crossing Alert Line at ", Price1, "!");
      }
      
      if(UseSendMail)
      {
         SendMail("Price Crossing Alert Line at " + Price1 + "!", "This is an email from the JC - Line Break Alert indicator. Price is crossing your alert line at " + Price1 + "!");
      }
   }
}

//+------------------------------------------------------------------+

void ChannelBreakOut()
{
   int counted_bars = IndicatorCounted();
   int pos = Bars-counted_bars;
   
   double LastPrice;
   double CurrentPrice;
   int x;
   
   while(pos>=0)
   {
      PRICE1[pos]= Price1;
      PRICE2[pos]= Price2;
      
      pos--;
   }
   
   if(UseTickMode)
   {
      LastPrice = iClose(NULL, 0, 1);
      CurrentPrice = iClose(NULL, 0, 0);
   }
   else if(UseTickMode == False)
   {
      LastPrice = iOpen(NULL, 0, 1);
      CurrentPrice = iOpen(NULL, 0, 0);
   }

   //int counter = 0;
   
   //while(!ObjectCreate("Price1_" + counter, OBJ_HLINE, 0, 0, Price1) && counter < 100)
   //{
   //   counter++;
   //}
   
   //while((!ObjectCreate("Price2_" + counter, OBJ_HLINE, 0, 0, Price2)) && counter < 100)
   //{
   //   counter++;
   //}
   
   //ObjectSet("Price1", OBJPROP_COLOR, Green);
   //ObjectSet("Price2", OBJPROP_COLOR, Red);
   
   if((LastPrice < Price1) && (CurrentPrice >= Price1) && !DidBreakout) 
   {
      if(DeactivateOnAlert)
      {
         DidBreakout = True;
      }
      
      if(UseSoundAlert)
      {
         for(x=0;x<=PlaySoundNTimes;x++)
         {
            PlaySound(SoundFile);
         }
      }
      
      if(UseAlertPopUp)
      {
         Alert("Channel Breaking Up at ", Price1, "!");
      }
      
      if(UseSendMail)
      {
         SendMail("Channel Breaking Up at " + Price1 + "!", "This is an email from the JC - Line Break Alert indicator. Price broke up your channel alert line at " + Price1 + "!");
      }
   }
   
   if((LastPrice > Price2) && (CurrentPrice <= Price2) && !DidBreakout)
   {
      if(DeactivateOnAlert)
      {
      DidBreakout = True;
      }
      
      if(UseSoundAlert)
      {
         for(x=0;x<=PlaySoundNTimes;x++)
         {
            PlaySound(SoundFile);
         }
      }
      
      if(UseAlertPopUp)
      {
         Alert("Channel Breaking Down at ", Price2, "!");
      }
      
      if(UseSendMail)
      {
         SendMail("Channel Breaking Down at " + Price2 + "!", "This is an email from the JC - Line Break Alert indicator. Price broke down your channel alert line at " + Price2 + "!");
      }
   }
}

//+------------------------------------------------------------------+